SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `beta_content` (
  `ID` bigint(20) NOT NULL auto_increment,
  `Crag` varchar(64) NOT NULL default '',
  `Route_Name` varchar(64) NOT NULL default '',
  `Active` char(1) NOT NULL default '',
  `Date_Created` date NOT NULL default '0000-00-00',
  `Date_Modified` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`ID`),
  KEY `Headline` (`Route_Name`),
  KEY `Date_Created` (`Date_Created`),
  KEY `Date_Modified` (`Date_Modified`),
  KEY `Active` (`Active`)
) TYPE=MyISAM;

insert into `beta_content` values('1','Kama Bay Cliffs','Deception Chimney','Y','2003-12-24','2005-12-14'),
 ('2','Kama Bay Cliffs','NC-17','Y','2004-02-23','2005-12-14'),
 ('3','Kama Bay Cliffs','Utthita','Y','2004-02-23','2005-12-14'),
 ('4','Thunder Bay','Domino Theory','Y','2004-02-23','2005-12-14'),
 ('5','Wyalusing','Junk Yard Dog','Y','2004-02-23','2005-12-14'),
 ('6','Orient Bay','Remember the Day','Y','2004-02-24','2005-12-14'),
 ('7','Lone Rock','Upriver','Y','2005-01-11','2005-12-14'),
 ('8','North of Thunder Bay','Harvester Of Sorrow','Y','2005-02-03','2005-12-14'),
 ('9','Border to Thunder Bay','Memory Road','Y','2004-02-23','2005-12-14'),
 ('10','Kama Bay Cliffs','Asymmetric Warfare','Y','2005-12-14','2005-12-14');

CREATE TABLE `beta_crag` (
  `id` int(11) NOT NULL auto_increment,
  `Crag_Crag` varchar(64) NOT NULL default '',
  `Crag_Active` char(1) NOT NULL default '',
  `Crag_Area` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

insert into `beta_crag` values('1','Kama Bay Cliffs','Y','Kama Bay'),
 ('2','Orient Bay','Y','Orient Bay'),
 ('3','North of Thunder Bay','Y','Thunder Bay'),
 ('4','Border to Thunder Bay','Y','Thunder Bay'),
 ('6','Wyalusing','Y','Southern WI'),
 ('7','Lone Rock','Y','Southern WI');

CREATE TABLE `beta_errors` (
  `id` int(11) NOT NULL auto_increment,
  `Code` int(4) NOT NULL default '0',
  `Title` varchar(128) NOT NULL default '',
  `Message` varchar(255) NOT NULL default '',
  `Attrib` varchar(4) default '',
  PRIMARY KEY  (`id`),
  KEY `Code` (`Code`)
) TYPE=MyISAM;

insert into `beta_errors` values('1','0','No Error','Operation successful.','Pos'),
 ('2','1001','Required Information Missing','Please review your entries and re-submit.','Neg'),
 ('3','1002','Required Information Missing','The value entered for <b><form_input></b> cannot be blank. Please click BACK on your browser and enter valid information.','Neg'),
 ('4','5027','Add Successful','Record was added successfully.','Pos'),
 ('5','5033','File Error','Sorry, an error occurred trying to read a file. Possibly no file was selected to upload or the wrong file type was used (try .jpg).','Neg'),
 ('6','5060','File Upload Error','Sorry, your file was not uploaded because it is an invalid file type. Please use JPEG.','Neg'),
 ('7','5061','File Upload Successful','The file upload was successful.','Pos'),
 ('8','9000','ERROR','Some type of other error occurred.','Neg'),
 ('9','9001','ERROR','<form_input>','Neg');

CREATE TABLE `beta_images` (
  `id` int(11) NOT NULL auto_increment,
  `Image_ContentID` int(11) NOT NULL default '0',
  `Image_Name` varchar(48) NOT NULL default '',
  `Image_Title` varchar(64) default NULL,
  `Image_Caption` varchar(255) default '',
  `Image_Credits` varchar(255) default '',
  `Image_DateCreated` date default '0000-00-00',
  `Date_Modified` date default '0000-00-00',
  PRIMARY KEY  (`id`),
  KEY `Image_Name` (`Image_Name`),
  KEY `Image_ContentID` (`Image_ContentID`)
) TYPE=MyISAM;

insert into `beta_images` values('48','10','Asymmetric_Warfare_MG_Cma.jpg',null,'Matt Giambrone on the first ascent of Asymmetric Warfare, a fearsome crack with \"not much ice\" located at kilometer 4 at Kama Bay.','Nick Buda','2005-12-15','0000-00-00');

SET FOREIGN_KEY_CHECKS = 1;